# Practical Usage of `bitvec` Structures

There are several different reasons you might be interested in a `[u1]` slice or
a `Vec<u1>` buffer. Each of these cases might use `bitvec` in a different way to
fulfill their needs. `bitvec`’s aim as a crate is to be a solid foundational
library for anyone who needs to view memory as a sequence of bits, rather than
of bytes.

This document accepts submissions!

## I/O Buffers

Many I/O protocols use sub-byte fields. This was the primary inspiration for
writing the crate; a network transport protocol allowed atoms to have arbitrary
bit widths in the stream, and each atom might have its own bit order within its
span, and the transport layer was further free to use a bit order and element
size of its choice.

Bit-serial protocol streams have a situational advantage that we can model them
as a source that produces individual bits over time. The interface to such a
source then requires that we specify how the serial stream moves each bit into
or out of our buffers. That specification is what the combination of `Cursor`
and `BitStore` type parameters on `bitvec`’s data structures encode.

### Streaming Input

`bitvec` does not export any queue types at this time, so, using a `BitVec` to
collect data from an I/O port is typically an append-only activity
